/* %W% %E% */
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            RINEX.h
 * version:         0503.27
 * written by:      M. Schenewerk
 * purpose:         data structures and variables to read RINEX files
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9612.15, MSS, Creation
 *:0110.26, MSS, Increase line size and "get" to better handle DOS files.
 *:0503.27, MSS, Increased MAX_LINE and added MAX_VALID_LINE to better
 *:              handle corrupt lines.
 ********1*********2*********3*********4*********5*********6*********7*********/

#ifndef _RINEX_h
#define _RINEX_h

#ifndef EDIT
#define EDIT	((double)-9999.0)
#endif

#ifndef MAX_LINE
#define MAX_LINE	((int)255)
#endif
#ifndef MAX_VALID_LINE
#define MAX_VALID_LINE	((int)81)
#endif

#ifndef MAXSV
#define MAXSV	((int)36)
#endif

#define MAX_VALUES_PER_LINE	((int)5)
#define PRN_MAX			((int)36)
#define TYPE_LENGTH		((int)6)
#define TYPE_MAX		((int)9)
#define TYPE_L1			"    L1"
#define TYPE_L2			"    L2"
#define TYPE_C1			"    C1"
#define TYPE_P1			"    P1"
#define TYPE_P2			"    P2"
#define TYPE_D1			"    D1"
#define TYPE_D2			"    D2"
#define TYPE_T1			"    T1"
#define TYPE_T2			"    T2"
#define VALUE_LENGTH		((int)16)
#define VALUE_MAX		((int)20)

struct RINEX_obs {
	long mjd;
	double day;
	int nsv;
	int sv[MAXSV];
	double L1phs[MAXSV];
	double L1rng[MAXSV];
	double L2phs[MAXSV];
	double L2rng[MAXSV];
};

#endif /* _RINEX_h */
