/*  @(#)dayhms.c	1.1  98/12/08  */
static char *sccsid= "@(#)dayhms.c	1.1  98/12/08";

/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/


/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

void dayhms( double, int *, int *, double * );

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/




/********1*********2*********3*********4*********5*********6*********7*********/
void dayhms( double TLO, int *hour, int *minute, double *second )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            dayhms
 * version:         9012.29
 * written by:      M. Schenewerk
 * purpose:         converts decimal days to hours, minutes, and seconds
 *
 * input parameters
 * ----------------
 * TLO              fractional (low) part of the time [decimal day]
 *
 * output parameters
 * -----------------
 * hour             hours [two digits - 24 hour international]
 * minute           minutes [two digits]
 * second           seconds
 *
 *
 * local variables and constants
 * -----------------------------
 * ltmp             temporary storage of converted decimal time
 * ROUND            additive constant which helps control rounding
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       general use
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        Precision limits conversion to 1/100 of a second
 *                  from a 4 byte single precision number.
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9012.29, mss, standard header
 ********1*********2*********3*********4*********5*********6*********7*********
 */

{
	long ltmp;

	ltmp= TLO;
	TLO -= (double)ltmp;

	TLO= TLO*24.0;
	*hour= TLO;
	TLO -= (double)(*hour);

	TLO= TLO*60.0;
	*minute= TLO;
	TLO -= (double)(*minute);

	TLO= TLO*60.0;
	*second= TLO;

	return;

}
