/*  @(#)hmsday.c	1.1  98/12/08  */
static char *sccsid= "@(#)hmsday.c	1.1  98/12/08";

/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/


/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

double hmsday( int, int, double );

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/




/********1*********2*********3*********4*********5*********6*********7*********/
double hmsday( int HOUR, int MINUTE, double SECOND )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            hmsday
 * version:         9012.31
 * written by:      M. Schenewerk
 * purpose:         converts hours, minutes, and seconds to decimal days
 *
 * input parameters
 * ----------------
 * HOUR             hours [two digits - 24 hour international]
 * MINUTE           minutes [two digits]
 * SECOND           seconds
 *
 * output parameters
 * -----------------
 * hmsday           equivalent time in decimal days
 *
 *
 * local variables and constants
 * -----------------------------
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       general use
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        four byte single precision limits the precision of the
 *                  return value to approximately 1/100 second
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9012.31, mss, standard header
 ********1*********2*********3*********4*********5*********6*********7*********
 */

{
   return( (double)HOUR/(double)24.0 + (double)MINUTE/(double)1440.0 + (double)SECOND/(double)86400.0 );
}
