/* @(#)gpscal.c	1.1  98/12/10 */
static char *sccsid= "@(#)gpscal.c	1.1  98/12/10";
/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/

#include <stdio.h>

/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

long ymdmjd();
int dow();
int gpswk();
int main();
void mjdymd();

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/

static char *mon_name[]=	{ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
							  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"  };


/********1*********2*********3*********4*********5*********6*********7*********/
main( argc, argv )
int argc;
char *argv[];
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            gpscal
 * version:         9307.27
 * written by:      M. Schenewerk
 * purpose:         Prints a calendar with day-of-year and GPS week
 *
 * input parameters
 * ----------------
 *
 * output parameters
 * -----------------
 *
 *
 * local variables and constants
 * -----------------------------
 * cal_dom          array containing day-of-month
 * cal_doy          array containing day-of-year
 * cal_gpswk        array containing GPS week numbers
 * days_in_month    number of days in the requested month
 * i                counter
 * imon             month
 * ione             (int)1
 * iyr              year
 * izero            (int)0
 * j                counter
 * k                counter
 * start_gpswk      GPS week for first day of requested month
 * start_dow        day-of-week for first day of requested month
 * start_doy        doy-of-year for first day of requested month
 * zero             (float)0.0
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   stdio.h
 *
 * references:      
 *
 * comments:        
 *
 * see also:        CLibtime library
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9307.27, MSS, Converted from FORTRAN.
 ********1*********2*********3*********4*********5*********6*********7*********/

{

	char cal_gpswk[6][6], cal_dom[42][4], cal_doy[42][4];
	int iyr, imon, start_dow, start_gpswk, start_doy, days_in_month;
	int i, j, k;
	static float zero= 0.0;
	static int ione= 1, izero= 0;

/********1*********2*********3*********4*********5*********6*********7*********
 *   0.0  explicit initialization of arrays
 ********1*********2*********3*********4*********5*********6*********7*********/

	for( i= 0; i < 42; i++ )
	{
		strcpy( cal_dom[i], " " );
		strcpy( cal_doy[i], " " );
	}
	for( i= 0; i < 6; i++ )
	{
		strcpy( cal_gpswk[i], " " );
	}

/********1*********2*********3*********4*********5*********6*********7*********
 *   1.0  interpret command line
 ********1*********2*********3*********4*********5*********6*********7*********/

	if( argc == 3 )
	{
		iyr= atoi( argv[1] );
		imon= atoi( argv[2] );
		if( imon > 12 )
			mjdymd( (long)(imon+ymdmjd(iyr,ione,izero)), &iyr, &imon, &i );
		else
			mjdymd( (long)(ymdmjd(iyr,imon,ione)), &iyr, &imon, &i );
	}
	else
	{
		printf( "%s: year [month or doy]\n", argv[0] );
		exit( 1 );
	}

/********1*********2*********3*********4*********5*********6*********7*********
 *   2.0  define variable describing requested month
 ********1*********2*********3*********4*********5*********6*********7*********/

	start_dow= dow( ymdmjd( iyr, imon, ione ) );
	start_doy= ymdmjd( iyr, imon, ione ) - ymdmjd( iyr, ione, izero );
	start_gpswk= gpswk( ymdmjd( iyr, imon, ione ) );
	days_in_month= ymdmjd( iyr, imon+1, ione ) - ymdmjd( iyr, imon, ione );
	j= 0;
	for( i= 0; i < days_in_month; i++ )
	{
		k= start_dow + i;
		sprintf( cal_dom[k], "%3d", 1+i );
		sprintf( cal_doy[k], "%3d", start_doy+i );
		if( j == 0 || k%7 == 0 )
		{
			sprintf( cal_gpswk[j], "%5d", start_gpswk+j );
			j++;
		}
	}

/********1*********2*********3*********4*********5*********6*********7*********
 *   3.0  print calendars
 ********1*********2*********3*********4*********5*********6*********7*********/

	printf( "                    %s             %4d                  %s\n",
		mon_name[imon-1], iyr, mon_name[imon-1] );
	printf( " GPS WK  Sun Mon Tue Wed Thu Fri Sat   GPS WK  Sun Mon Tue Wed Thu Fri Sat\n" );
	j= 0;
	for( i= 0; i < start_dow+days_in_month; i += 7 )
	{
		printf( " %5s  ", cal_gpswk[j] );
		for( k= i; k < i+7; k++ ) printf( " %3s", cal_dom[k] );
		printf( "   %5s  ", cal_gpswk[j] );
		for( k= i; k < i+7; k++ ) printf( " %3s", cal_doy[k] );
		j++;
		putchar( '\n' );
	}

	exit( 0 );
}
