/* @(#)xyz2neu.c	1.2 00/04/10 */
static char *sccsid= "@(#)xyz2neu.c	1.2 00/04/10";
/********1*********2*********3*********4*********5*********6*********7**
 * Name:        xyz2neu
 * Version:     0004.08
 * Author:      M. Schenewerk
 * Purpose:     local X/Y/Z vector to N/E/U
 *
 * Input:
 * -----------
 *
 * Output:
 * -----------
 *
 * Local:
 * -----------
 * c                command-line flag character
 * errflg           command-line error flag
 * pgm              program name
 * ptr              scratch string pointer
 * vrsn             program version number
 *
 *
 * Global:
 * -----------
 * eflat             Earth flattening factor
 * emajor            Earth's semi-major axis [m]
 *
 *
 * Include files:
 * -----------
 * physcon.h        physical constants
 *
 * Calls:
 * -----------
 *
 * Notes:
 * -----------
 *
 * References:
 * -----------
 *
 ********1*********2*********3*********4*********5*********6*********7**
 *:Modification History:
 *:0004.08, MSS, Creation
 ********1*********2*********3*********4*********5*********6*********7*/
#ifndef _INCLUDE_POSIX_SOURCE
#  define _INCLUDE_POSIX_SOURCE
#endif
/*
 *	include files
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <math.h>
#include <math.h>
#include "physcon.h"

/*
 *	definitions and global variables
 */


/*
 *	function prototypes
 */

int main( int, char ** );
void neu2xyz( double, double, double, double, double,
        double *, double *, double * );
void xyz2neu( double, double, double, double, double,
        double *, double *, double * );
void xyz2plh( double *, double *, double, double );



main( int argc, char *argv[] )
{
  char *pgm;
  char *ptr;
  char vrsn[]= { "0004.08" };

  double valin[3];
  double valout[3];
  double plh[3];

  int c;
  int errflg= 0;
  int Reverse= 0;
  int Xyz= 0;

  extern char *optarg;
  extern int optind;
  extern int optopt;

/*
 *......  0.0  Initialization
 */

  pgm= argv[0];
  while( (ptr= strpbrk( pgm, "/\\:" )) != NULL )
    pgm= ptr+1;

/*
 *......  1.0  Parse command line
 */

  while( (c= getopt(argc, argv, ":hr")) != -1 )
    switch( c ) {
    case 'h':
      ++errflg;
      break;
    case 'r':
      Reverse= 1;
      break;
    case '?':
      fprintf(stderr, "%s ERROR: Unrecognized option \"%c\"\n",
         pgm, optopt);
      ++errflg;
      break;
    case ':':
      ++errflg;
      break;
    }

  if( errflg || (argc-optind) < 5 || (argc-optind) > 6 ) {
    fprintf(stderr, "%s(%s): Local X/Y/Z to N/E/U vector.\n", pgm, vrsn );
    fprintf(stderr, "Usage:     %s {-hr} lat lon {hgt} Vx Vy Vz\n", pgm);
    fprintf(stderr, "Alternate: %s {-hr} X Y Z Vx Vy Vz\n", pgm);
    fprintf(stderr, "       where -h = generates this help message,\n");
    fprintf(stderr, "             -r = reverse: vector N/E/U to X/Y/Z.\n");
    exit( 1 );
  }

  if( (argc-optind) == 5 ) {
    plh[0]= atof( argv[optind] );
    if( plh[0] <  -90.0 || plh[0] >  90.0 ) {
      fprintf(stderr, "%s ERROR: latitude out of bounds = \"%s\"\n",
         pgm, argv[optind]);
      ++errflg;
    }
    ++optind;

    plh[1]= atof( argv[optind] );
    if( plh[1] < -360.0 || plh[0] > 360.0 ) {
      fprintf(stderr, "%s ERROR: longitude out of bounds = \"%s\"\n",
         pgm, argv[optind]);
      ++errflg;
    }
    ++optind;

    plh[2]= 0.0;
  } else {
    valin[0]= atof( argv[optind] );
    if( valin[0] <  -90.0 || valin[0] >  90.0 )
      ++Xyz;
    ++optind;

    valin[1]= atof( argv[optind] );
    if( valin[1] < -360.0 || valin[0] > 360.0 )
      ++Xyz;
    ++optind;

    valin[2]= atof( argv[optind] );
    if( valin[2] < -5000.0 || valin[0] > 5000.0 )
      ++Xyz;
    ++optind;

    if( Xyz > 0 ) {
      xyz2plh( valin, plh, emajor, eflat );
    } else {
      plh[0]= valin[0];
      plh[1]= valin[1];
      plh[2]= valin[2];
    }
  }

  valin[0]= atof( argv[optind] );
  ++optind;

  valin[1]= atof( argv[optind] );
  ++optind;

  valin[2]= atof( argv[optind] );
  ++optind;

/*
 *......  2.0  Make and print conversion
 */

  if( Reverse ) {
    neu2xyz( plh[0], plh[1], valin[0], valin[1], valin[2],
        valout, valout+1, valout+2 );
  } else {
    xyz2neu( plh[0], plh[1], valin[0], valin[1], valin[2],
        valout, valout+1, valout+2 );
  }
  printf( "%lf %lf %lf\n", valout[0], valout[1], valout[2] );

  exit( 0 );
}
