/*  @(#)mjdymd.c	1.1  98/12/08  */
static char *sccsid= "@(#)mjdymd.c	1.1  98/12/08";

/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/


/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

void mjdymd( long, int *, int *, int * );

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/

#define DAYS_PER_CENTURY	36524.25
#define DAYS_PER_MONTH		30.6001
#define DAYS_PER_YEAR		365.25
#define MJD_OFFSET			(long)2400001



/********1*********2*********3*********4*********5*********6*********7*********/
void mjdymd( long THI, int *year, int *month, int *day )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            mjdymd
 * version:         9012.29
 * written by:      M. Schenewerk
 * purpose:         converts modified Julian day to Gregorian calendar date
 *
 * input parameters
 * ----------------
 * THI              integer (high) part of the time [MJD]
 *
 * output parameters
 * -----------------
 * year             year [four digit]
 * month            month [two digits]
 * day              day [two digits]
 *
 *
 * local variables and constants
 * -----------------------------
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       general use
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9012.29, mss, standard header
 ********1*********2*********3*********4*********5*********6*********7*********
 */

{
	long C, E, I, JD;
	int i, D, G;

/*
 *	convert to Julian date
 */
	JD= I= ( THI < MJD_OFFSET ) ? THI + MJD_OFFSET : THI;

	if( I > 229916 )
		I= ( I - 1867216.25 )/DAYS_PER_CENTURY;
	C= (long)( JD + (long)( 1 + I - (long)( I*0.25 ) ) ) + 1524;
	D= ( C - 122.1 )/DAYS_PER_YEAR;
	E= DAYS_PER_YEAR*D;
	G= ( C - E )/DAYS_PER_MONTH;

	*day= C - E - (int)( G*DAYS_PER_MONTH );
	*month= ( G > 13.5 ) ? G - 13: G - 1;
	*year= D - 4715;
	if( *month > 2.5 )
		*year= *year - 1;

	return;

}
