/*  @(#)tchkeps.c	1.1  98/12/08  */
static char *sccsid= "@(#)tchkeps.c	1.1  98/12/08";

/*
 *  include files
 */


/*
 *  function prototypes
 */

int tchkeps( long, double, long, double, double );

/*
 *  global definitions and variables
 */

int tchkeps( long mjd1, double day1, long mjd2, double day2, double eps )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            tchkeps
 * version:         9509.25
 * written by:      M. Schenewerk
 * purpose:         compares two times to within some user defined uncertainty
 *
 * input parameters
 * ----------------
 * day1             decimal (low) part of first time [day]
 * day2             decimal (low) part of second time [day]
 * mjd1             integer (high) part of first time [MJD]
 * mjd2             integer (high) part of second time [MJD]
 * eps              largest allowable difference between the times
 *
 * output parameters
 * -----------------
 * tchkeps          return value <0 => time 1 < time 2
 *                                0 => time 1 = time 2
 *                               >0 => time 1 > time 2
 *
 *
 * local variables and constants
 * -----------------------------
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9509.25, MSS, Creation
 ********1*********2*********3*********4*********5*********6*********7*********/
{
	double dummy;
	int flag;

	if( (dummy= ((double)(mjd1 - mjd2) + day1 - day2 )) < -eps )
		flag= -1;
	else if( dummy >  eps )
		flag=  1;
	else
		flag= 0;

	return( flag );
}
