/* %W%  %G% */
/*
 *  include files
 */

#include <stdio.h>
#include <unistd.h>

/*
 *  function prototypes
 */

int main( int, char ** );
int ReadRINEXObsTypes( FILE *, int, int *, char ** );
int WriteRINEXHeader( FILE *, FILE * );
int WriteRINEXObs( FILE *, FILE *, int, char ** );

/*
 *  global definitions and variables
 */

#define FILENAME_LENGTH		65
#define OBS_MAX			10
#define VERSION			"0210.15"

int user_int= 0;

static char *sccsid= "%W%  %G%";


int main( int argc, char *argv[] )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            cato
 * version:         9610.07
 * written by:      M. Schenewerk
 * purpose:         cat RINEX observation ("o") files into a consistent file
 *
 * input parameters
 * ----------------
 *
 * output parameters
 * -----------------
 *
 *
 * local variables and constants
 * -----------------------------
 *
 * global variables and constants
 * ------------------------------
 * user_int         user specified date interval [sec]
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9506.23, MSS, Creation
 *:9510.26, MSS, Found one case where NULL was placed in 17 rather than 16.
 *:              Substituded defined constants for values.
 *:9610.07, MSS, added user specified data interval
 ********1*********2*********3*********4*********5*********6*********7*********/
{
	extern char  *optarg;
	extern int   optind, optopt;

	char         *pgm;
	char         afile[FILENAME_LENGTH];
	char         *master[OBS_MAX];
	int          c;
	int          flag_error= 0;
	int          ios;
	int          nfile;
	int          nmaster= 0;
	FILE         *pfile= NULL;
/*
 *   0.0  parse command line
 */
	pgm= argv[0];

	while( (c= getopt(argc,argv,"i:")) != EOF ) {
		switch( c ) {
		case 'i':
			user_int= atoi( optarg );
			break;
		case '?':
			flag_error= 1;
			break;
		}
	} 

	if( flag_error > 0 || argc < 2 ) {
		fprintf( stderr, "Usage(%s): %s {-i interval} file file{s}\n", VERSION, pgm );
		exit(1);
	}
/*
 *  1.0  read header block of first file for master list of observable types
 */
	/*nfile= 1;*/
	nfile= optind;
	strcpy(afile, argv[nfile]);
	if( (pfile= fopen( afile, "r" )) == NULL ) {
		fprintf( stderr, "%s(%s): Error opening file %d = \"%s\"\n",
		pgm, VERSION, nfile, afile );
		exit(nfile);
	}

	ios= ReadRINEXObsTypes( pfile, OBS_MAX, &nmaster, master );
	if( ios != 0 ) {
		fprintf( stderr, "%s(%s): Error reading obs types for file %d = \"%s\"\n",
		pgm, VERSION, nfile, afile );
		exit(nfile);
	}
/*
 *  2.0  output first file header and data
 */
	ios= WriteRINEXHeader( stdout, pfile );
	if( ios != 0 ) {
		fprintf( stderr, "%s(%s): Error reading header for file %d = \"%s\"\n",
		pgm, VERSION, nfile, afile );
		exit(nfile);
	}
	ios= WriteRINEXObs( stdout, pfile, nmaster, master );
	if( ios == 0 ) {
		fprintf( stderr, "%s(%s): Error reading data for file %d = \"%s\"\n",
		pgm, VERSION, nfile, afile );
		exit(nfile);
	}
	fclose( pfile );
/*
 *  3.0  output all other files data
 */
	while( ++nfile < argc ) {
		strcpy(afile, argv[nfile]);
		if( (pfile= fopen( afile, "r" )) == NULL ) {
			fprintf( stderr, "%s(%s): Error opening file %d = \"%s\"\n",
			pgm, VERSION, nfile, afile );
			exit(nfile);
		}

		ios= WriteRINEXObs( stdout, pfile, nmaster, master );
		if( ios == 0 ) {
			fprintf( stderr, "%s(%s): Error reading data for file %d = \"%s\"\n",
			pgm, VERSION, nfile, afile );
			exit(nfile);
		}

		fclose( pfile );
	}
}
