/* @(#)dmjd.c	1.3  05/11/99 */
static char *sccsid= "@(#)dmjd.c	1.3  05/11/99";

/*
 *  include files
 */

#include <stdio.h>
#include <stdlib.h>

/*
 *  function prototypes
 */

double hmsday();
long ymdmjd();
void dayhms();
void mjdymd();

/*
 *  global definitions and variables
 */




int main( int argc, char **argv )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            dmjd
 * version:         9905.10
 * written by:      M. Schenewerk
 * purpose:         Converts the date and time to the Modified Julian date
 *
 * input parameters
 * ----------------
 *
 * output parameters
 * -----------------
 *
 *
 * local variables and constants
 * -----------------------------
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9707.10, MSS, Creation.
 *:9905.10, MSS, Trap decimal times rounded to 1.0 and modify the MJD.
 ********1*********2*********3*********4*********5*********6*********7*********/

{
  double day;
  double isec;
  int iday, imon, iyr;
  int imin, ihr;
  int ione= 1, izero= 0;
  long mjd;

  if( argc != 2 && argc != 6 && argc != 7 ) {
    fprintf(stderr,"Usage: %s yy mm dd hh mm ss.ss or\n",argv[0]);
    fprintf(stderr,"Usage: %s yy doy hh mm ss.ss or\n",argv[0]);
    fprintf(stderr,"Usage: %s ddddd\n",argv[0]);
    exit(1);
  }

  if( argc == 7 ) {
    iyr= atoi( argv[1] );
    imon= atoi( argv[2] );
    iday= atoi( argv[3] );
    ihr= atoi( argv[4] );
    imin= atoi( argv[5] );
    isec= atoi( argv[6] );
    printf( "%lf\n", (double)ymdmjd( iyr, imon, iday ) +
                      hmsday( ihr, imin, isec ) );
  } else if( argc == 6 ) {
    iyr= atoi( argv[1] );
    iday= atoi( argv[2] );
    ihr= atoi( argv[3] );
    imin= atoi( argv[4] );
    isec= atoi( argv[5] );
    printf( "%lf\n", (double)(ymdmjd( iyr, ione, izero ) + iday) +
                      hmsday( ihr, imin, isec ) );
  } else {
    mjd= atol( argv[1] );
    day= atof( argv[1] ) - (double)mjd + 5.787e-6;
    if( day > 1.0 ) {
      mjd += (long)day;
      day -= 1.0;
    }
    mjdymd( mjd, &iyr, &imon, &iday );
    dayhms( day, &ihr, &imin, &isec );
    printf( "%d %d %d %d %d %d\n",
        iyr, imon, iday, ihr, imin, (int)isec );
  }

  exit( 0 );
}
