/*  @(#)ymdmjd.c	1.1  98/12/08  */
static char *sccsid= "@(#)ymdmjd.c	1.1  98/12/08";

/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/


/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

long ymdmjd( int, int, int );

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/

#define MJD0			-(long)679006
#define DAYS_IN_YEAR	365.25
#define DAYS_IN_MONTH	30.6001



/********1*********2*********3*********4*********5*********6*********7*********/
long ymdmjd( int YEAR, int MONTH, int DAY )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            ymdmjd
 * version:         9012.31
 * written by:      M. Schenewerk
 * purpose:         conerts year, month, and day to the modified Julian date
 *
 * input parameters
 * ----------------
 * YEAR             year [four digits]
 * MONTH            month [two digits]
 * DAY              day [two digits]
 *
 * output parameters
 * -----------------
 * ymdmjd           modified Julian date
 *
 *
 * local variables and constants
 * -----------------------------
 * mo               temporary storage of month
 * yr               temporary storage of year
 * A                temporary variable
 * B                temporary variable
 * C                temporary variable
 * D                temporary variable
 * DAYS_IN_YEAR     average number of days in one year
 * DAYS_IN_MONTH    average number of days in one month
 * MJD0             reference modified Julian date
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       general use
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9012.31, mss, standard header
 ********1*********2*********3*********4*********5*********6*********7*********
 */

{
	long A, B, C, D;

	if( YEAR < 78 )
		YEAR += 2000;
	else if( YEAR < 100 )
		YEAR += 1900;

	if( MONTH < 3 )
	{
		YEAR -= 1;
		MONTH += 12;
	}

	A= YEAR/100;
	B= 2 - A + A/4;
	C= DAYS_IN_YEAR*(float)YEAR;
	D= DAYS_IN_MONTH*(float)( MONTH + 1 );

	return( B + C + D + (long)DAY + MJD0 );
}
