/*  @(#)gpswk.c	1.1  98/12/08  */
static char *sccsid= "@(#)gpswk.c	1.1  98/12/08";

/********1*********2*********3*********4*********5*********6*********7*********/
/*  include files                                                             */
/********1*********2*********3*********4*********5*********6*********7*********/


/********1*********2*********3*********4*********5*********6*********7*********/
/*  function prototypes                                                       */
/********1*********2*********3*********4*********5*********6*********7*********/

int gpswk( long );

/********1*********2*********3*********4*********5*********6*********7*********/
/*  global definitions and variables                                          */
/********1*********2*********3*********4*********5*********6*********7*********/

#define DAYOFF			((long)4)
#define WEEKOFF			((long)6320)



/********1*********2*********3*********4*********5*********6*********7*********/
int gpswk( long THI )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            gpswk
 * version:         9012.31
 * written by:      M. Schenewerk
 * purpose:         converts modified Julian date to the GPS week
 *
 * input parameters
 * ----------------
 * THI              modified Julian date [mjd]
 *
 * output parameters
 * -----------------
 * gpswk            corresponding GPS week
 *
 *
 * local variables and constants
 * -----------------------------
 * DAYOFF           offset to mjd 0 day of week [days]
 * WEEKOFF          offset of first GPS week [weeks]
 *
 * global variables and constants
 * ------------------------------
 *
 *
 * called by:       general use
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9012.31, mss, standard header
 ********1*********2*********3*********4*********5*********6*********7*********
 */

{
	return( (int)( ( THI - DAYOFF )/(long)7 - WEEKOFF ) );
}
