/*  @(#)xyz2neu.c	1.1  98/12/08  */
static char *sccsid= "@(#)xyz2neu.c	1.1  98/12/08";
/*
 *  include files
 */

#include <math.h>
#include "physcon.h"

/*
 *  function prototypes
 */

void xyz2neu( double, double, double, double, double,
	double *, double *, double * );


void xyz2neu( double lat, double lon, double X, double Y, double Z,
	double *N, double *E, double *U )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            xyz2neu
 * version:         9406.24
 * written by:      M. Schenewerk
 * purpose:         Convert geocentric X, Y, Z vector to local north, east, up
 *
 * input parameters
 * ----------------
 * lat              site latitude [deg]
 * lon              site longitude [deg]
 * X                geocentric X vector component
 * Y                geocentric Y vector component
 * Z                geocentric Z vector component
 *
 * output parameters
 * -----------------
 * E                topocentric east vector component
 * N                topocentric north vector component
 * U                topocentric up vector component
 *
 *
 * local variables and constants
 * -----------------------------
 * clat             cosine of the latitude
 * clon             cosine of the longitude
 * slat             sine of the latitude
 * slon             sine of the longitude
 *
 * global variables and constants
 * ------------------------------
 * deg_to_rad       degree to radian conversion factor
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        neu2xyz
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9006.06, MSS, Doc. standard implimented
 *:9406.24, MSS, Converted from Fortran
 ********1*********2*********3*********4*********5*********6*********7*********/

{

	double clat;
	double clon;
	double slat;
	double slon;

	clat= cos( deg_to_rad * lat );
	slat= sin( deg_to_rad * lat );
	clon= cos( deg_to_rad * lon );
	slon= sin( deg_to_rad * lon );

	*E= -X*slon + Y*clon;
	*N= -X*slat*clon - Y*slat*slon + Z*clat;
	*U= +X*clat*clon + Y*clat*slon + Z*slat;

}
