/*  @(#)neu2xyz.c	1.1  98/12/08  */
static char *sccsid= "@(#)neu2xyz.c	1.1  98/12/08";
/*
 *  include files
 */

#include <math.h>
#include "physcon.h"

/*
 *  function prototypes
 */

void neu2xyz( double, double, double, double, double,
	double *, double *, double * );


void neu2xyz( double lat, double lon, double N, double E, double U,
	double *X, double *Y, double *Z )
/********1*********2*********3*********4*********5*********6*********7*********
 * name:            neu2xyz
 * version:         9811.19
 * written by:      M. Schenewerk
 * purpose:         Convert local north, east, up vector to X, Y, Z
 *
 * input parameters
 * ----------------
 * lat              site latitude [deg]
 * lon              site longitude [deg]
 * E                topocentric east vector component
 * N                topocentric north vector component
 * U                topocentric up vector component
 *
 * output parameters
 * -----------------
 * X                geocentric X vector component
 * Y                geocentric Y vector component
 * Z                geocentric Z vector component
 *
 *
 * local variables and constants
 * -----------------------------
 * clat             cosine of the latitude
 * clon             cosine of the longitude
 * slat             sine of the latitude
 * slon             sine of the longitude
 *
 * global variables and constants
 * ------------------------------
 * deg_to_rad       degree to radian conversion factor
 *
 *
 * called by:       
 *
 * calls:           
 *
 * include files:   
 *
 * references:      
 *
 * comments:        
 *
 * see also:        xyz2neu
 *
 ********1*********2*********3*********4*********5*********6*********7*********
 *:modification history
 *:9006.06, MSS, Doc. standard implimented
 *:9406.24, MSS, Converted from Fortran
 *:9811.19, MSS, Include the math header file for function definitions.
 ********1*********2*********3*********4*********5*********6*********7*********/

{

	double clat;
	double clon;
	double slat;
	double slon;

	clat= cos( deg_to_rad * lat );
	slat= sin( deg_to_rad * lat );
	clon= cos( deg_to_rad * lon );
	slon= sin( deg_to_rad * lon );

	*X= -N*slat*clon - E*slon + U*clat*clon;
	*Y= -N*slat*slon + E*clon + U*clat*slon;
	*Z=  N*clat + U*slat;

}
